'use strict';

$(document).ready(function() {
	$('.datatablesz').DataTable({
		"drawCallback": function(settings) {
			feather.replace();
		},
		"language": {
			"emptyTable": "Data tidak ada yang tersedia",
			"info": "Tampilan _START_ sampai _END_ dari _TOTAL_ entri",
			"infoEmpty": "Tampilan 0 sampai 0 dari 0 entri",
			"lengthMenu": "Tampil _MENU_ entri",
			"search": "Cari:",
			"zeroRecords": "Tidak ada data ditemukan",
			"paginate": {
				"previous": "Sebelum",
				"next": "Berikut",
				"last": "Terakhir",
				"first": "Pertama"
			}
		},
		dom: '<"d-flex justify-content-between align-items-center mx-0 row"<"col-sm-12 col-md-6"l><"col-sm-12 col-md-6"f>>t<"d-flex justify-content-between mx-0 row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
	});
});

function delSwal(id, filename, info = '', rb = '', delay = 0) {
	if (info == '') {
		info = 'Anda tidak dapat mengembalikan data ini!';
	} else {
		info = 'Akan menghapus data ' + info + ' secara permanen!';
	}
	Swal.fire({
		title: 'Apa anda yakin?',
		text: info,
		icon: 'warning',
		showCancelButton: true,
		confirmButtonText: 'Ya, dihapus!',
		cancelButtonText: 'Batal',
		customClass: {
			confirmButton: 'btn btn-danger',
			cancelButton: 'btn btn-outline-success ms-1'
		},
		buttonsStyling: false,
		allowOutsideClick: false,
	}).then(function(result) {
		if (result.value) {
			$.ajax({
				url: filename,
				type: "POST",
				data: {
					id: id,
					rb: rb
				},
				success: function(data) {
					msgToast('Sukses!', 'Sudah berhasil menghapus data ...', 'success', delay);
				},
				error: function(data) {
					alert(data.error);
				}
			}).done(function(result) {
				// location.reload();
			});
		}
	});
}

function msgSwal(title, text, icon = 'success') {
	Swal.fire({
		title: title,
		text: text,
		icon: icon,
		showConfirmButton: true
	})
}

function msgToast(title, text, icon = 'success', delay = 0) {
	var isRtl = $('html').attr('data-textdirection') === 'rtl';
	toastr[icon](
		text,
		title, {
			closeButton: true,
			tapToDismiss: false,
			rtl: isRtl
		}
	);
	if (delay > 0) {
		setTimeout(function() {
			location.reload();
		}, delay);
	}
}

function startBlockUI(bui='block-ui'){
	$("#" + bui).block({
		message: '<div class="spinner-border text-white" role="status"></div>',
		css: {
			backgroundColor: 'transparent',
			border: '0'
		},
		overlayCSS: {
			opacity: 0.5
		}
	});
}

function stopBlockUI(bui='block-ui'){
	$("#" + bui).unblock();
}

function startSpinner(id, txt='Diproses...'){
	$(id).html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span><span class="ms-25 align-middle"> ' + txt + '</span>');
}

function stopSpinner(id, icon, txt=''){
	$(id).html('<i data-feather="'+icon+'"></i> '+txt);
}

function checkNumberRange(input, min, max) {
    var originalValue = input.value;
    if (input.value < min || input.value > max) {
        alert("Nilai harus dalam batasan " + min + " sampai dengan " + max);
        input.value = originalValue;
        input.focus();
    }
}

$(function() {
	$("[rel='tooltip']").tooltip();

	$("body").tooltip({
		selector: '[rel="tooltip"]'
	});

	$('[rel=tooltip]').tooltip({
		trigger: "hover"
	});

	$('[rel="tooltip"]').click(function() {
		$('[rel="tooltip"]').tooltip("hide");
	});
});
